<?php
/**
 * @package         FireBox
 * @version         2.1.12 Free
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2024 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace FireBox\Core\Blocks;

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}

abstract class FormBlock extends Block
{
	protected function getBlockSourceDir($block = '')
	{
		$ds = DIRECTORY_SEPARATOR;

		return implode($ds, [rtrim(FBOX_PLUGIN_DIR, $ds), 'media', 'admin', 'js', 'blocks', 'form', $block, 'block.json']);
	}
}