<?php
/**
 * @package         FirePlugins Framework
 * @version         1.1.99
 * 
 * @author          FirePlugins <info@fireplugins.com>
 * @link            https://www.fireplugins.com
 * @copyright       Copyright © 2024 FirePlugins All Rights Reserved
 * @license         GNU GPLv3 <http://www.gnu.org/licenses/gpl.html> or later
*/

namespace FPFramework\Libs;

if (!defined('ABSPATH'))
{
	exit; // Exit if accessed directly.
}

class GoogleFonts
{
	/**
	 * Returns all Google Fonts names.
	 * 
	 * @return  array
	 */
	public static function getFontsNames()
	{
		return ['ABeeZee','Abel','Abhaya Libre','Abril Fatface','Aclonica','Acme','Actor','Adamina','Advent Pro','Aguafina Script','Akaya Kanadaka','Akaya Telivigala','Akronim','Aladin','Alata','Alatsi','Aldrich','Alef','Alegreya','Alegreya SC','Alegreya Sans','Alegreya Sans SC','Aleo','Alex Brush','Alfa Slab One','Alice','Alike','Alike Angular','Allan','Allerta','Allerta Stencil','Allura','Almarai','Almendra','Almendra Display','Almendra SC','Amarante','Amaranth','Amatic SC','Amethysta','Amiko','Amiri','Amita','Anaheim','Andada','Andika','Andika New Basic','Angkor','Annie Use Your Telescope','Anonymous Pro','Antic','Antic Didone','Antic Slab','Anton','Antonio','Arapey','Arbutus','Arbutus Slab','Architects Daughter','Archivo','Archivo Black','Archivo Narrow','Aref Ruqaa','Arima Madurai','Arimo','Arizonia','Armata','Arsenal','Artifika','Arvo','Arya','Asap','Asap Condensed','Asar','Asset','Assistant','Astloch','Asul','Athiti','Atma','Atomic Age','Aubrey','Audiowide','Autour One','Average','Average Sans','Averia Gruesa Libre','Averia Libre','Averia Sans Libre','Averia Serif Libre','B612','B612 Mono','Bad Script','Bahiana','Bahianita','Bai Jamjuree','Ballet','Baloo 2','Baloo Bhai 2','Baloo Bhaina 2','Baloo Chettan 2','Baloo Da 2','Baloo Paaji 2','Baloo Tamma 2','Baloo Tammudu 2','Baloo Thambi 2','Balsamiq Sans','Balthazar','Bangers','Barlow','Barlow Condensed','Barlow Semi Condensed','Barriecito','Barrio','Basic','Baskervville','Battambang','Baumans','Bayon','Be Vietnam','Bebas Neue','Belgrano','Bellefair','Belleza','Bellota','Bellota Text','BenchNine','Benne','Bentham','Berkshire Swash','Beth Ellen','Bevan','Big Shoulders Display','Big Shoulders Inline Display','Big Shoulders Inline Text','Big Shoulders Stencil Display','Big Shoulders Stencil Text','Big Shoulders Text','Bigelow Rules','Bigshot One','Bilbo','Bilbo Swash Caps','BioRhyme','BioRhyme Expanded','Biryani','Bitter','Black And White Picture','Black Han Sans','Black Ops One','Blinker','Bodoni Moda','Bokor','Bona Nova','Bonbon','Boogaloo','Bowlby One','Bowlby One SC','Brawler','Bree Serif','Brygada 1918','Bubblegum Sans','Bubbler One','Buda','Buenard','Bungee','Bungee Hairline','Bungee Inline','Bungee Outline','Bungee Shade','Butcherman','Butterfly Kids','Cabin','Cabin Condensed','Cabin Sketch','Caesar Dressing','Cagliostro','Cairo','Caladea','Calistoga','Calligraffitti','Cambay','Cambo','Candal','Cantarell','Cantata One','Cantora One','Capriola','Cardo','Carme','Carrois Gothic','Carrois Gothic SC','Carter One','Castoro','Catamaran','Caudex','Caveat','Caveat Brush','Cedarville Cursive','Ceviche One','Chakra Petch','Changa','Changa One','Chango','Charm','Charmonman','Chathura','Chau Philomene One','Chela One','Chelsea Market','Chenla','Cherry Cream Soda','Cherry Swash','Chewy','Chicle','Chilanka','Chivo','Chonburi','Cinzel','Cinzel Decorative','Clicker Script','Coda','Coda Caption','Codystar','Coiny','Combo','Comfortaa','Comic Neue','Coming Soon','Commissioner','Concert One','Condiment','Content','Contrail One','Convergence','Cookie','Copse','Corben','Cormorant','Cormorant Garamond','Cormorant Infant','Cormorant SC','Cormorant Unicase','Cormorant Upright','Courgette','Courier Prime','Cousine','Coustard','Covered By Your Grace','Crafty Girls','Creepster','Crete Round','Crimson Pro','Crimson Text','Croissant One','Crushed','Cuprum','Cute Font','Cutive','Cutive Mono','DM Mono','DM Sans','DM Serif Display','DM Serif Text','Damion','Dancing Script','Dangrek','Darker Grotesque','David Libre','Dawning of a New Day','Days One','Dekko','Dela Gothic One','Delius','Delius Swash Caps','Delius Unicase','Della Respira','Denk One','Devonshire','Dhurjati','Didact Gothic','Diplomata','Diplomata SC','Do Hyeon','Dokdo','Domine','Donegal One','Doppio One','Dorsa','Dosis','DotGothic16','Dr Sugiyama','Duru Sans','Dynalight','EB Garamond','Eagle Lake','East Sea Dokdo','Eater','Economica','Eczar','El Messiri','Electrolize','Elsie','Elsie Swash Caps','Emblema One','Emilys Candy','Encode Sans','Encode Sans Condensed','Encode Sans Expanded','Encode Sans SC','Encode Sans Semi Condensed','Encode Sans Semi Expanded','Engagement','Englebert','Enriqueta','Epilogue','Erica One','Esteban','Euphoria Script','Ewert','Exo','Exo 2','Expletus Sans','Fahkwang','Fanwood Text','Farro','Farsan','Fascinate','Fascinate Inline','Faster One','Fasthand','Fauna One','Faustina','Federant','Federo','Felipa','Fenix','Festive','Finger Paint','Fira Code','Fira Mono','Fira Sans','Fira Sans Condensed','Fira Sans Extra Condensed','Fjalla One','Fjord One','Flamenco','Flavors','Fondamento','Fontdiner Swanky','Forum','Francois One','Frank Ruhl Libre','Fraunces','Freckle Face','Fredericka the Great','Fredoka One','Freehand','Fresca','Frijole','Fruktur','Fugaz One','Fuggles','GFS Didot','GFS Neohellenic','Gabriela','Gaegu','Gafata','Galada','Galdeano','Galindo','Gamja Flower','Gayathri','Gelasio','Gentium Basic','Gentium Book Basic','Geo','Geostar','Geostar Fill','Germania One','Gidugu','Gilda Display','Girassol','Give You Glory','Glass Antiqua','Glegoo','Gloria Hallelujah','Goblin One','Gochi Hand','Goldman','Gorditas','Gothic A1','Gotu','Goudy Bookletter 1911','Graduate','Grand Hotel','Grandstander','Gravitas One','Great Vibes','Grenze','Grenze Gotisch','Griffy','Gruppo','Gudea','Gugi','Gupter','Gurajada','Habibi','Hachi Maru Pop','Halant','Hammersmith One','Hanalei','Hanalei Fill','Handlee','Hanuman','Happy Monkey','Harmattan','Headland One','Heebo','Henny Penny','Hepta Slab','Herr Von Muellerhoff','Hi Melody','Hind','Hind Guntur','Hind Madurai','Hind Siliguri','Hind Vadodara','Holtwood One SC','Homemade Apple','Homenaje','IBM Plex Mono','IBM Plex Sans','IBM Plex Sans Condensed','IBM Plex Serif','IM Fell DW Pica','IM Fell DW Pica SC','IM Fell Double Pica','IM Fell Double Pica SC','IM Fell English','IM Fell English SC','IM Fell French Canon','IM Fell French Canon SC','IM Fell Great Primer','IM Fell Great Primer SC','Ibarra Real Nova','Iceberg','Iceland','Imbue','Imprima','Inconsolata','Inder','Indie Flower','Inika','Inknut Antiqua','Inria Sans','Inria Serif','Inter','Irish Grover','Istok Web','Italiana','Italianno','Itim','Jacques Francois','Jacques Francois Shadow','Jaldi','JetBrains Mono','Jim Nightshade','Jockey One','Jolly Lodger','Jomhuria','Jomolhari','Josefin Sans','Josefin Slab','Jost','Joti One','Jua','Judson','Julee','Julius Sans One','Junge','Jura','Just Another Hand','Just Me Again Down Here','K2D','Kadwa','Kalam','Kameron','Kanit','Kantumruy','Karantina','Karla','Karma','Katibeh','Kaushan Script','Kavivanar','Kavoon','Kdam Thmor','Keania One','Kelly Slab','Kenia','Khand','Khmer','Khula','Kirang Haerang','Kite One','Kiwi Maru','Knewave','KoHo','Kodchasan','Kosugi','Kosugi Maru','Kotta One','Koulen','Kranky','Kreon','Kristi','Krona One','Krub','Kufam','Kulim Park','Kumar One','Kumar One Outline','Kumbh Sans','Kurale','La Belle Aurore','Lacquer','Laila','Lakki Reddy','Lalezar','Lancelot','Langar','Lateef','Lato','League Script','Leckerli One','Ledger','Lekton','Lemon','Lemonada','Lexend','Lexend Deca','Lexend Exa','Lexend Giga','Lexend Mega','Lexend Peta','Lexend Tera','Lexend Zetta','Libre Barcode 128','Libre Barcode 128 Text','Libre Barcode 39','Libre Barcode 39 Extended','Libre Barcode 39 Extended Text','Libre Barcode 39 Text','Libre Barcode EAN13 Text','Libre Baskerville','Libre Caslon Display','Libre Caslon Text','Libre Franklin','Life Savers','Lilita One','Lily Script One','Limelight','Linden Hill','Literata','Liu Jian Mao Cao','Livvic','Lobster','Lobster Two','Londrina Outline','Londrina Shadow','Londrina Sketch','Londrina Solid','Long Cang','Lora','Love Ya Like A Sister','Loved by the King','Lovers Quarrel','Luckiest Guy','Lusitana','Lustria','M PLUS 1p','M PLUS Rounded 1c','Ma Shan Zheng','Macondo','Macondo Swash Caps','Mada','Magra','Maiden Orange','Maitree','Major Mono Display','Mako','Mali','Mallanna','Mandali','Manjari','Manrope','Mansalva','Manuale','Marcellus','Marcellus SC','Marck Script','Margarine','Markazi Text','Marko One','Marmelad','Martel','Martel Sans','Marvel','Mate','Mate SC','Maven Pro','McLaren','Meddon','MedievalSharp','Medula One','Meera Inimai','Megrim','Meie Script','Merienda','Merienda One','Merriweather','Merriweather Sans','Metal','Metal Mania','Metamorphous','Metrophobic','Michroma','Milonga','Miltonian','Miltonian Tattoo','Mina','Miniver','Miriam Libre','Mirza','Miss Fajardose','Mitr','Modak','Modern Antiqua','Mogra','Molengo','Molle','Monda','Monofett','Monoton','Monsieur La Doulaise','Montaga','Montez','Montserrat','Montserrat Alternates','Montserrat Subrayada','Moul','Moulpali','Mountains of Christmas','Mouse Memoirs','Mr Bedfort','Mr Dafoe','Mr De Haviland','Mrs Saint Delafield','Mrs Sheppards','Mukta','Mukta Mahee','Mukta Malar','Mukta Vaani','Mulish','MuseoModerno','Mystery Quest','NTR','Nanum Brush Script','Nanum Gothic','Nanum Gothic Coding','Nanum Myeongjo','Nanum Pen Script','Nerko One','Neucha','Neuton','New Rocker','New Tegomin','News Cycle','Newsreader','Niconne','Niramit','Nixie One','Nobile','Nokora','Norican','Nosifer','Notable','Nothing You Could Do','Noticia Text','Noto Sans','Noto Sans HK','Noto Sans JP','Noto Sans KR','Noto Sans SC','Noto Sans TC','Noto Serif','Noto Serif JP','Noto Serif KR','Noto Serif SC','Noto Serif TC','Nova Cut','Nova Flat','Nova Mono','Nova Oval','Nova Round','Nova Script','Nova Slim','Nova Square','Numans','Nunito','Nunito Sans','Odibee Sans','Odor Mean Chey','Offside','Oi','Old Standard TT','Oldenburg','Oleo Script','Oleo Script Swash Caps','Open Sans','Open Sans Condensed','Oranienbaum','Orbitron','Oregano','Orelega One','Orienta','Original Surfer','Oswald','Otomanopee One','Over the Rainbow','Overlock','Overlock SC','Overpass','Overpass Mono','Ovo','Oxanium','Oxygen','Oxygen Mono','PT Mono','PT Sans','PT Sans Caption','PT Sans Narrow','PT Serif','PT Serif Caption','Pacifico','Padauk','Palanquin','Palanquin Dark','Pangolin','Paprika','Parisienne','Passero One','Passion One','Pathway Gothic One','Patrick Hand','Patrick Hand SC','Pattaya','Patua One','Pavanam','Paytone One','Peddana','Peralta','Permanent Marker','Petit Formal Script','Petrona','Philosopher','Piazzolla','Piedra','Pinyon Script','Pirata One','Plaster','Play','Playball','Playfair Display','Playfair Display SC','Podkova','Poiret One','Poller One','Poly','Pompiere','Pontano Sans','Poor Story','Poppins','Port Lligat Sans','Port Lligat Slab','Potta One','Pragati Narrow','Prata','Preahvihear','Press Start 2P','Pridi','Princess Sofia','Prociono','Prompt','Prosto One','Proza Libre','Public Sans','Puritan','Purple Purse','Qahiri','Quando','Quantico','Quattrocento','Quattrocento Sans','Questrial','Quicksand','Quintessential','Qwigley','Racing Sans One','Radley','Rajdhani','Rakkas','Raleway','Raleway Dots','Ramabhadra','Ramaraja','Rambla','Rammetto One','Ranchers','Rancho','Ranga','Rasa','Rationale','Ravi Prakash','Recursive','Red Hat Display','Red Hat Text','Red Rose','Redressed','Reem Kufi','Reenie Beanie','Reggae One','Revalia','Rhodium Libre','Ribeye','Ribeye Marrow','Righteous','Risque','Roboto','Roboto Condensed','Roboto Mono','Roboto Slab','Rochester','Rock Salt','RocknRoll One','Rokkitt','Romanesco','Ropa Sans','Rosario','Rosarivo','Rouge Script','Rowdies','Rozha One','Rubik','Rubik Mono One','Ruda','Rufina','Ruge Boogie','Ruluko','Rum Raisin','Ruslan Display','Russo One','Ruthie','Rye','STIX Two Math','Sacramento','Sahitya','Sail','Saira','Saira Condensed','Saira Extra Condensed','Saira Semi Condensed','Saira Stencil One','Salsa','Sanchez','Sancreek','Sansita','Sansita Swashed','Sarabun','Sarala','Sarina','Sarpanch','Satisfy','Sawarabi Gothic','Sawarabi Mincho','Scada','Scheherazade','Schoolbell','Scope One','Seaweed Script','Secular One','Sedgwick Ave','Sedgwick Ave Display','Sen','Sevillana','Seymour One','Shadows Into Light','Shadows Into Light Two','Shanti','Share','Share Tech','Share Tech Mono','Shippori Mincho','Shippori Mincho B1','Shojumaru','Short Stack','Shrikhand','Siemreap','Sigmar One','Signika','Signika Negative','Simonetta','Single Day','Sintony','Sirin Stencil','Six Caps','Skranji','Slabo 13px','Slabo 27px','Slackey','Smokum','Smythe','Sniglet','Snippet','Snowburst One','Sofadi One','Sofia','Solway','Song Myung','Sonsie One','Sora','Sorts Mill Goudy','Source Code Pro','Source Sans Pro','Source Serif Pro','Space Grotesk','Space Mono','Spartan','Special Elite','Spectral','Spectral SC','Spicy Rice','Spinnaker','Spirax','Squada One','Sree Krushnadevaraya','Sriracha','Srisakdi','Staatliches','Stalemate','Stalinist One','Stardos Stencil','Stick','Stint Ultra Condensed','Stint Ultra Expanded','Stoke','Strait','Stylish','Sue Ellen Francisco','Suez One','Sulphur Point','Sumana','Sunflower','Sunshiney','Supermercado One','Sura','Suranna','Suravaram','Suwannaphum','Swanky and Moo Moo','Syncopate','Syne','Syne Mono','Syne Tactile','Tajawal','Tangerine','Taprom','Tauri','Taviraj','Teko','Telex','Tenali Ramakrishna','Tenor Sans','Text Me One','Texturina','Thasadith','The Girl Next Door','Tienne','Tillana','Timmana','Tinos','Titan One','Titillium Web','Tomorrow','Tourney','Trade Winds','Train One','Trirong','Trispace','Trocchi','Trochut','Truculenta','Trykker','Tulpen One','Turret Road','Ubuntu','Ubuntu Condensed','Ubuntu Mono','Uchen','Ultra','Uncial Antiqua','Underdog','Unica One','UnifrakturCook','UnifrakturMaguntia','Unkempt','Unlock','Unna','VT323','Vampiro One','Varela','Varela Round','Varta','Vast Shadow','Vesper Libre','Viaoda Libre','Vibes','Vibur','Vidaloka','Viga','Voces','Volkhov','Vollkorn','Vollkorn SC','Voltaire','Waiting for the Sunrise','Wallpoet','Walter Turncoat','Warnes','Wellfleet','Wendy One','Wire One','Work Sans','Xanh Mono','Yanone Kaffeesatz','Yantramanav','Yatra One','Yellowtail','Yeon Sung','Yeseva One','Yesteryear','Yomogi','Yrsa','Yusei Magic','ZCOOL KuaiLe','ZCOOL QingKe HuangYou','ZCOOL XiaoWei','Zen Dots','Zen Loop','Zen Tokyo Zoo','Zeyada','Zhi Mang Xing','Zilla Slab','Zilla Slab Highlight'];
	}

	/**
	 * Returns all Google Fonts and their styles.
	 * 
	 * @return  array
	 */
	public static function getFonts()
	{
		return ['ABeeZee' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Abel' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Abhaya Libre' => ['v' => ['400','500','600','700','800'],'s' => ['latin','latin-ext','sinhala'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Abril Fatface' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Aclonica' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Acme' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Actor' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Adamina' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Advent Pro' => ['v' => ['100','200','300','400','500','600','700'],'s' => ['greek','latin','latin-ext'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400']],'Aguafina Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Akaya Kanadaka' => ['v' => ['400'],'s' => ['kannada','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Akaya Telivigala' => ['v' => ['400'],'s' => ['latin','latin-ext','telugu'],'w' => ['400'],'i' => ['400']],'Akronim' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Aladin' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Alata' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Alatsi' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Aldrich' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Alef' => ['v' => ['400','700'],'s' => ['hebrew','latin'],'w' => ['400','700'],'i' => ['400']],'Alegreya' => ['v' => ['400','500','600','700','800','900','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','900','500italic','700italic','900italic'],'i' => ['400','italic']],'Alegreya SC' => ['v' => ['400','italic','500','500italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['400','500','700','800','900'],'i' => ['400','italic']],'Alegreya Sans' => ['v' => ['100','100italic','300','300italic','400','italic','500','500italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','700','800','900'],'i' => ['400','italic']],'Alegreya Sans SC' => ['v' => ['100','100italic','300','300italic','400','italic','500','500italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','700','800','900'],'i' => ['400','italic']],'Aleo' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400','italic']],'Alex Brush' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Alfa Slab One' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Alice' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin'],'w' => ['400'],'i' => ['400']],'Alike' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Alike Angular' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Allan' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Allerta' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Allerta Stencil' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Allura' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Almarai' => ['v' => ['300','400','700','800'],'s' => ['arabic'],'w' => ['300','400','700','800'],'i' => ['400']],'Almendra' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Almendra Display' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Almendra SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Amarante' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Amaranth' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Amatic SC' => ['v' => ['400','700'],'s' => ['cyrillic','hebrew','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Amethysta' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Amiko' => ['v' => ['400','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','600','700'],'i' => ['400']],'Amiri' => ['v' => ['400','italic','700','700italic'],'s' => ['arabic','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Amita' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Anaheim' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Andada' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Andika' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Andika New Basic' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Angkor' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Annie Use Your Telescope' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Anonymous Pro' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','greek','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Antic' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Antic Didone' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Antic Slab' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Anton' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Antonio' => ['v' => ['100','200','300','400','500','600','700'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400']],'Arapey' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Arbutus' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Arbutus Slab' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Architects Daughter' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Archivo' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Archivo Black' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Archivo Narrow' => ['v' => ['400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700'],'i' => ['400','italic']],'Aref Ruqaa' => ['v' => ['400','700'],'s' => ['arabic','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Arima Madurai' => ['v' => ['100','200','300','400','500','700','800','900'],'s' => ['latin','latin-ext','tamil','vietnamese'],'w' => ['100','200','300','400','500','700','800','900'],'i' => ['400']],'Arimo' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','hebrew','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Arizonia' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Armata' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Arsenal' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Artifika' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Arvo' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Arya' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Asap' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Asap Condensed' => ['v' => ['400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700'],'i' => ['400','italic']],'Asar' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Asset' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Assistant' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['hebrew','latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Astloch' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Asul' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Athiti' => ['v' => ['200','300','400','500','600','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400']],'Atma' => ['v' => ['300','400','500','600','700'],'s' => ['bengali','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Atomic Age' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Aubrey' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Audiowide' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Autour One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Average' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Average Sans' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Averia Gruesa Libre' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Averia Libre' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin'],'w' => ['300','400','700'],'i' => ['400','italic']],'Averia Sans Libre' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin'],'w' => ['300','400','700'],'i' => ['400','italic']],'Averia Serif Libre' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin'],'w' => ['300','400','700'],'i' => ['400','italic']],'B612' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'B612 Mono' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Bad Script' => ['v' => ['400'],'s' => ['cyrillic','latin'],'w' => ['400'],'i' => ['400']],'Bahiana' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Bahianita' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Bai Jamjuree' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Ballet' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Baloo 2' => ['v' => ['400','500','600','700','800'],'s' => ['devanagari','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Bhai 2' => ['v' => ['400','500','600','700','800'],'s' => ['gujarati','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Bhaina 2' => ['v' => ['400','500','600','700','800'],'s' => ['latin','latin-ext','oriya','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Chettan 2' => ['v' => ['400','500','600','700','800'],'s' => ['latin','latin-ext','malayalam','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Da 2' => ['v' => ['400','500','600','700','800'],'s' => ['bengali','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Paaji 2' => ['v' => ['400','500','600','700','800'],'s' => ['gurmukhi','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Tamma 2' => ['v' => ['400','500','600','700','800'],'s' => ['kannada','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Tammudu 2' => ['v' => ['400','500','600','700','800'],'s' => ['latin','latin-ext','telugu','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Baloo Thambi 2' => ['v' => ['400','500','600','700','800'],'s' => ['latin','latin-ext','tamil','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Balsamiq Sans' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Balthazar' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bangers' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Barlow' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Barlow Condensed' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Barlow Semi Condensed' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Barriecito' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Barrio' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Basic' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Baskervville' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Battambang' => ['v' => ['400','700'],'s' => ['khmer'],'w' => ['400','700'],'i' => ['400']],'Baumans' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bayon' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Be Vietnam' => ['v' => ['100','100italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800'],'i' => ['400','italic']],'Bebas Neue' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Belgrano' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bellefair' => ['v' => ['400'],'s' => ['hebrew','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Belleza' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Bellota' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['300','400','700'],'i' => ['400','italic']],'Bellota Text' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['300','400','700'],'i' => ['400','italic']],'BenchNine' => ['v' => ['300','400','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400']],'Benne' => ['v' => ['400'],'s' => ['kannada','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Bentham' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Berkshire Swash' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Beth Ellen' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bevan' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Big Shoulders Display' => ['v' => ['100','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800','900'],'i' => ['400']],'Big Shoulders Inline Display' => ['v' => ['100','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800','900'],'i' => ['400']],'Big Shoulders Inline Text' => ['v' => ['100','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800','900'],'i' => ['400']],'Big Shoulders Stencil Display' => ['v' => ['100','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800','900'],'i' => ['400']],'Big Shoulders Stencil Text' => ['v' => ['100','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800','900'],'i' => ['400']],'Big Shoulders Text' => ['v' => ['100','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800','900'],'i' => ['400']],'Bigelow Rules' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Bigshot One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bilbo' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Bilbo Swash Caps' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'BioRhyme' => ['v' => ['200','300','400','700','800'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','700','800'],'i' => ['400']],'BioRhyme Expanded' => ['v' => ['200','300','400','700','800'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','700','800'],'i' => ['400']],'Biryani' => ['v' => ['200','300','400','600','700','800','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['200','300','400','600','700','800','900'],'i' => ['400']],'Bitter' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Black And White Picture' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Black Han Sans' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Black Ops One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Blinker' => ['v' => ['100','200','300','400','600','700','800','900'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','600','700','800','900'],'i' => ['400']],'Bodoni Moda' => ['v' => ['400','500','600','700','800','900','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700','800','900','500italic','700italic','900italic'],'i' => ['400','italic']],'Bokor' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Bona Nova' => ['v' => ['400','italic','700'],'s' => ['cyrillic','cyrillic-ext','greek','hebrew','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Bonbon' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Boogaloo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bowlby One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bowlby One SC' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Brawler' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Bree Serif' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Brygada 1918' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Bubblegum Sans' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Bubbler One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Buda' => ['v' => ['300'],'s' => ['latin'],'w' => ['300'],'i' => ['400']],'Buenard' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Bungee' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Bungee Hairline' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Bungee Inline' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Bungee Outline' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Bungee Shade' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Butcherman' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Butterfly Kids' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Cabin' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Cabin Condensed' => ['v' => ['400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700'],'i' => ['400']],'Cabin Sketch' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Caesar Dressing' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Cagliostro' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Cairo' => ['v' => ['200','300','400','600','700','900'],'s' => ['arabic','latin','latin-ext'],'w' => ['200','300','400','600','700','900'],'i' => ['400']],'Caladea' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Calistoga' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Calligraffitti' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Cambay' => ['v' => ['400','italic','700','700italic'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Cambo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Candal' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Cantarell' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Cantata One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Cantora One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Capriola' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Cardo' => ['v' => ['400','italic','700'],'s' => ['greek','greek-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Carme' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Carrois Gothic' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Carrois Gothic SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Carter One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Castoro' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Catamaran' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','tamil'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Caudex' => ['v' => ['400','italic','700','700italic'],'s' => ['greek','greek-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Caveat' => ['v' => ['400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','500','600','700'],'i' => ['400']],'Caveat Brush' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Cedarville Cursive' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Ceviche One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Chakra Petch' => ['v' => ['300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400','italic']],'Changa' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['arabic','latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Changa One' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Chango' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Charm' => ['v' => ['400','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Charmonman' => ['v' => ['400','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Chathura' => ['v' => ['100','300','400','700','800'],'s' => ['latin','telugu'],'w' => ['100','300','400','700','800'],'i' => ['400']],'Chau Philomene One' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Chela One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Chelsea Market' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Chenla' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Cherry Cream Soda' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Cherry Swash' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Chewy' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Chicle' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Chilanka' => ['v' => ['400'],'s' => ['latin','malayalam'],'w' => ['400'],'i' => ['400']],'Chivo' => ['v' => ['300','300italic','400','italic','700','700italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['300','400','700','900'],'i' => ['400','italic']],'Chonburi' => ['v' => ['400'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400'],'i' => ['400']],'Cinzel' => ['v' => ['400','500','600','700','800','900'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700','800','900'],'i' => ['400']],'Cinzel Decorative' => ['v' => ['400','700','900'],'s' => ['latin'],'w' => ['400','700','900'],'i' => ['400']],'Clicker Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Coda' => ['v' => ['400','800'],'s' => ['latin','latin-ext'],'w' => ['400','800'],'i' => ['400']],'Coda Caption' => ['v' => ['800'],'s' => ['latin','latin-ext'],'w' => ['800'],'i' => ['400']],'Codystar' => ['v' => ['300','400'],'s' => ['latin','latin-ext'],'w' => ['300','400'],'i' => ['400']],'Coiny' => ['v' => ['400'],'s' => ['latin','latin-ext','tamil','vietnamese'],'w' => ['400'],'i' => ['400']],'Combo' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Comfortaa' => ['v' => ['300','400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Comic Neue' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin'],'w' => ['300','400','700'],'i' => ['400','italic']],'Coming Soon' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Commissioner' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Concert One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Condiment' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Content' => ['v' => ['400','700'],'s' => ['khmer'],'w' => ['400','700'],'i' => ['400']],'Contrail One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Convergence' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Cookie' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Copse' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Corben' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Cormorant' => ['v' => ['300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400','italic']],'Cormorant Garamond' => ['v' => ['300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400','italic']],'Cormorant Infant' => ['v' => ['300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400','italic']],'Cormorant SC' => ['v' => ['300','400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Cormorant Unicase' => ['v' => ['300','400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Cormorant Upright' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Courgette' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Courier Prime' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Cousine' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','hebrew','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Coustard' => ['v' => ['400','900'],'s' => ['latin'],'w' => ['400','900'],'i' => ['400']],'Covered By Your Grace' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Crafty Girls' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Creepster' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Crete Round' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Crimson Pro' => ['v' => ['200','300','400','500','600','700','800','900','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800','900','300italic','500italic','700italic','900italic'],'i' => ['400','italic']],'Crimson Text' => ['v' => ['400','italic','600','600italic','700','700italic'],'s' => ['latin'],'w' => ['400','600','700'],'i' => ['400','italic']],'Croissant One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Crushed' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Cuprum' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Cute Font' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Cutive' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Cutive Mono' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'DM Mono' => ['v' => ['300','300italic','400','italic','500','500italic'],'s' => ['latin','latin-ext'],'w' => ['300','400','500'],'i' => ['400','italic']],'DM Sans' => ['v' => ['400','italic','500','500italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','700'],'i' => ['400','italic']],'DM Serif Display' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'DM Serif Text' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Damion' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Dancing Script' => ['v' => ['400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700'],'i' => ['400']],'Dangrek' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Darker Grotesque' => ['v' => ['300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700','800','900'],'i' => ['400']],'David Libre' => ['v' => ['400','500','700'],'s' => ['hebrew','latin','latin-ext','vietnamese'],'w' => ['400','500','700'],'i' => ['400']],'Dawning of a New Day' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Days One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Dekko' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Dela Gothic One' => ['v' => ['400'],'s' => ['cyrillic','greek','japanese','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Delius' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Delius Swash Caps' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Delius Unicase' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Della Respira' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Denk One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Devonshire' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Dhurjati' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Didact Gothic' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Diplomata' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Diplomata SC' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Do Hyeon' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Dokdo' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Domine' => ['v' => ['400','500','600','700'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700'],'i' => ['400']],'Donegal One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Doppio One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Dorsa' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Dosis' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'DotGothic16' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Dr Sugiyama' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Duru Sans' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Dynalight' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'EB Garamond' => ['v' => ['400','500','600','700','800','italic','500italic','600italic','700italic','800italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','500italic','700italic'],'i' => ['400','italic']],'Eagle Lake' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'East Sea Dokdo' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Eater' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Economica' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Eczar' => ['v' => ['400','500','600','700','800'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','500','600','700','800'],'i' => ['400']],'El Messiri' => ['v' => ['400','500','600','700'],'s' => ['arabic','cyrillic','latin'],'w' => ['400','500','600','700'],'i' => ['400']],'Electrolize' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Elsie' => ['v' => ['400','900'],'s' => ['latin','latin-ext'],'w' => ['400','900'],'i' => ['400']],'Elsie Swash Caps' => ['v' => ['400','900'],'s' => ['latin','latin-ext'],'w' => ['400','900'],'i' => ['400']],'Emblema One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Emilys Candy' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Encode Sans' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Encode Sans Condensed' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Encode Sans Expanded' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Encode Sans SC' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Encode Sans Semi Condensed' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Encode Sans Semi Expanded' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Engagement' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Englebert' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Enriqueta' => ['v' => ['400','500','600','700'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700'],'i' => ['400']],'Epilogue' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Erica One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Esteban' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Euphoria Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ewert' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Exo' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Exo 2' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Expletus Sans' => ['v' => ['400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin'],'w' => ['400','500','600','700'],'i' => ['400','italic']],'Fahkwang' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Fanwood Text' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Farro' => ['v' => ['300','400','500','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','500','700'],'i' => ['400']],'Farsan' => ['v' => ['400'],'s' => ['gujarati','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Fascinate' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Fascinate Inline' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Faster One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Fasthand' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Fauna One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Faustina' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Federant' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Federo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Felipa' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Fenix' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Festive' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Finger Paint' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Fira Code' => ['v' => ['300','400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Fira Mono' => ['v' => ['400','500','700'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext'],'w' => ['400','500','700'],'i' => ['400']],'Fira Sans' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Fira Sans Condensed' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Fira Sans Extra Condensed' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Fjalla One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Fjord One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Flamenco' => ['v' => ['300','400'],'s' => ['latin'],'w' => ['300','400'],'i' => ['400']],'Flavors' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Fondamento' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Fontdiner Swanky' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Forum' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Francois One' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Frank Ruhl Libre' => ['v' => ['300','400','500','700','900'],'s' => ['hebrew','latin','latin-ext'],'w' => ['300','400','500','700','900'],'i' => ['400']],'Fraunces' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Freckle Face' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Fredericka the Great' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Fredoka One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Freehand' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Fresca' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Frijole' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Fruktur' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Fugaz One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Fuggles' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'GFS Didot' => ['v' => ['400'],'s' => ['greek'],'w' => ['400'],'i' => ['400']],'GFS Neohellenic' => ['v' => ['400','italic','700','700italic'],'s' => ['greek'],'w' => ['400','700'],'i' => ['400','italic']],'Gabriela' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin'],'w' => ['400'],'i' => ['400']],'Gaegu' => ['v' => ['300','400','700'],'s' => ['korean','latin'],'w' => ['300','400','700'],'i' => ['400']],'Gafata' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Galada' => ['v' => ['400'],'s' => ['bengali','latin'],'w' => ['400'],'i' => ['400']],'Galdeano' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Galindo' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Gamja Flower' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Gayathri' => ['v' => ['100','400','700'],'s' => ['latin','malayalam'],'w' => ['100','400','700'],'i' => ['400']],'Gelasio' => ['v' => ['400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700'],'i' => ['400','italic']],'Gentium Basic' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Gentium Book Basic' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Geo' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Geostar' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Geostar Fill' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Germania One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Gidugu' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Gilda Display' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Girassol' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Give You Glory' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Glass Antiqua' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Glegoo' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Gloria Hallelujah' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Goblin One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Gochi Hand' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Goldman' => ['v' => ['400','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Gorditas' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Gothic A1' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['korean','latin'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Gotu' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Goudy Bookletter 1911' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Graduate' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Grand Hotel' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Grandstander' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Gravitas One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Great Vibes' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Grenze' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Grenze Gotisch' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Griffy' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Gruppo' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Gudea' => ['v' => ['400','italic','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Gugi' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Gupter' => ['v' => ['400','500','700'],'s' => ['latin'],'w' => ['400','500','700'],'i' => ['400']],'Gurajada' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Habibi' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Hachi Maru Pop' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Halant' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Hammersmith One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Hanalei' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Hanalei Fill' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Handlee' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Hanuman' => ['v' => ['400','700'],'s' => ['khmer'],'w' => ['400','700'],'i' => ['400']],'Happy Monkey' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Harmattan' => ['v' => ['400','700'],'s' => ['arabic','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Headland One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Heebo' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['hebrew','latin'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Henny Penny' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Hepta Slab' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Herr Von Muellerhoff' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Hi Melody' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Hind' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Hind Guntur' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','telugu'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Hind Madurai' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','tamil'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Hind Siliguri' => ['v' => ['300','400','500','600','700'],'s' => ['bengali','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Hind Vadodara' => ['v' => ['300','400','500','600','700'],'s' => ['gujarati','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Holtwood One SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Homemade Apple' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Homenaje' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'IBM Plex Mono' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400','italic']],'IBM Plex Sans' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400','italic']],'IBM Plex Sans Condensed' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400','italic']],'IBM Plex Serif' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400','italic']],'IM Fell DW Pica' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'IM Fell DW Pica SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'IM Fell Double Pica' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'IM Fell Double Pica SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'IM Fell English' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'IM Fell English SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'IM Fell French Canon' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'IM Fell French Canon SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'IM Fell Great Primer' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'IM Fell Great Primer SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Ibarra Real Nova' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Iceberg' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Iceland' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Imbue' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Imprima' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Inconsolata' => ['v' => ['200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800','900'],'i' => ['400']],'Inder' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Indie Flower' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Inika' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Inknut Antiqua' => ['v' => ['300','400','500','600','700','800','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700','800','900'],'i' => ['400']],'Inria Sans' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400','italic']],'Inria Serif' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400','italic']],'Inter' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Irish Grover' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Istok Web' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Italiana' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Italianno' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Itim' => ['v' => ['400'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400'],'i' => ['400']],'Jacques Francois' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Jacques Francois Shadow' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Jaldi' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'JetBrains Mono' => ['v' => ['100','200','300','400','500','600','700','800','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Jim Nightshade' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Jockey One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Jolly Lodger' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Jomhuria' => ['v' => ['400'],'s' => ['arabic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Jomolhari' => ['v' => ['400'],'s' => ['latin','tibetan'],'w' => ['400'],'i' => ['400']],'Josefin Sans' => ['v' => ['100','200','300','400','500','600','700','100italic','200italic','300italic','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','200italic','italic','600italic'],'i' => ['400','italic']],'Josefin Slab' => ['v' => ['100','200','300','400','500','600','700','100italic','200italic','300italic','italic','500italic','600italic','700italic'],'s' => ['latin'],'w' => ['100','200','300','400','500','600','700','200italic','italic','600italic'],'i' => ['400','italic']],'Jost' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Joti One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Jua' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Judson' => ['v' => ['400','italic','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Julee' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Julius Sans One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Junge' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Jura' => ['v' => ['300','400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Just Another Hand' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Just Me Again Down Here' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'K2D' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['100','200','300','400','500','600','700','800'],'i' => ['400','italic']],'Kadwa' => ['v' => ['400','700'],'s' => ['devanagari','latin'],'w' => ['400','700'],'i' => ['400']],'Kalam' => ['v' => ['300','400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400']],'Kameron' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Kanit' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Kantumruy' => ['v' => ['300','400','700'],'s' => ['khmer'],'w' => ['300','400','700'],'i' => ['400']],'Karantina' => ['v' => ['300','400','700'],'s' => ['hebrew','latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400']],'Karla' => ['v' => ['200','300','400','500','600','700','800','200italic','300italic','italic','500italic','600italic','700italic','800italic'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','500','600','700','800','300italic','500italic','700italic'],'i' => ['400','italic']],'Karma' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Katibeh' => ['v' => ['400'],'s' => ['arabic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kaushan Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kavivanar' => ['v' => ['400'],'s' => ['latin','latin-ext','tamil'],'w' => ['400'],'i' => ['400']],'Kavoon' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kdam Thmor' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Keania One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kelly Slab' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kenia' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Khand' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Khmer' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Khula' => ['v' => ['300','400','600','700','800'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','600','700','800'],'i' => ['400']],'Kirang Haerang' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Kite One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Kiwi Maru' => ['v' => ['300','400','500'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['300','400','500'],'i' => ['400']],'Knewave' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'KoHo' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Kodchasan' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Kosugi' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin'],'w' => ['400'],'i' => ['400']],'Kosugi Maru' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin'],'w' => ['400'],'i' => ['400']],'Kotta One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Koulen' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Kranky' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Kreon' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Kristi' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Krona One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Krub' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Kufam' => ['v' => ['400','500','600','700','800','900','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['arabic','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','900','500italic','700italic','900italic'],'i' => ['400','italic']],'Kulim Park' => ['v' => ['200','200italic','300','300italic','400','italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','600','700'],'i' => ['400','italic']],'Kumar One' => ['v' => ['400'],'s' => ['gujarati','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kumar One Outline' => ['v' => ['400'],'s' => ['gujarati','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Kumbh Sans' => ['v' => ['300','400','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400']],'Kurale' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'La Belle Aurore' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Lacquer' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Laila' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Lakki Reddy' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Lalezar' => ['v' => ['400'],'s' => ['arabic','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lancelot' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Langar' => ['v' => ['400'],'s' => ['gurmukhi','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Lateef' => ['v' => ['400'],'s' => ['arabic','latin'],'w' => ['400'],'i' => ['400']],'Lato' => ['v' => ['100','100italic','300','300italic','400','italic','700','700italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['100','300','400','700','900'],'i' => ['400','italic']],'League Script' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Leckerli One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Ledger' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Lekton' => ['v' => ['400','italic','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Lemon' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Lemonada' => ['v' => ['300','400','500','600','700'],'s' => ['arabic','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Lexend' => ['v' => ['100','300','400','500','600','700','800'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','600','700','800'],'i' => ['400']],'Lexend Deca' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lexend Exa' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lexend Giga' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lexend Mega' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lexend Peta' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lexend Tera' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lexend Zetta' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Libre Barcode 128' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Barcode 128 Text' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Barcode 39' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Barcode 39 Extended' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Barcode 39 Extended Text' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Barcode 39 Text' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Barcode EAN13 Text' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Libre Baskerville' => ['v' => ['400','italic','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Libre Caslon Display' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Libre Caslon Text' => ['v' => ['400','italic','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Libre Franklin' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Life Savers' => ['v' => ['400','700','800'],'s' => ['latin','latin-ext'],'w' => ['400','700','800'],'i' => ['400']],'Lilita One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Lily Script One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Limelight' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Linden Hill' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Literata' => ['v' => ['200','300','400','500','600','700','800','900','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800','900','300italic','500italic','700italic','900italic'],'i' => ['400','italic']],'Liu Jian Mao Cao' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'Livvic' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','900','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','900'],'i' => ['400','italic']],'Lobster' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Lobster Two' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Londrina Outline' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Londrina Shadow' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Londrina Sketch' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Londrina Solid' => ['v' => ['100','300','400','900'],'s' => ['latin'],'w' => ['100','300','400','900'],'i' => ['400']],'Long Cang' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'Lora' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Love Ya Like A Sister' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Loved by the King' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Lovers Quarrel' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Luckiest Guy' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Lusitana' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Lustria' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'M PLUS 1p' => ['v' => ['100','300','400','500','700','800','900'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','hebrew','japanese','latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','700','800','900'],'i' => ['400']],'M PLUS Rounded 1c' => ['v' => ['100','300','400','500','700','800','900'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','hebrew','japanese','latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','700','800','900'],'i' => ['400']],'Ma Shan Zheng' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'Macondo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Macondo Swash Caps' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Mada' => ['v' => ['200','300','400','500','600','700','900'],'s' => ['arabic','latin'],'w' => ['200','300','400','500','600','700','900'],'i' => ['400']],'Magra' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Maiden Orange' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Maitree' => ['v' => ['200','300','400','500','600','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400']],'Major Mono Display' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Mako' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Mali' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Mallanna' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Mandali' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Manjari' => ['v' => ['100','400','700'],'s' => ['latin','latin-ext','malayalam'],'w' => ['100','400','700'],'i' => ['400']],'Manrope' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['cyrillic','greek','latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Mansalva' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Manuale' => ['v' => ['400','500','600','700','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','500italic','700italic'],'i' => ['400','italic']],'Marcellus' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Marcellus SC' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Marck Script' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Margarine' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Markazi Text' => ['v' => ['400','500','600','700'],'s' => ['arabic','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700'],'i' => ['400']],'Marko One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Marmelad' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Martel' => ['v' => ['200','300','400','600','700','800','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['200','300','400','600','700','800','900'],'i' => ['400']],'Martel Sans' => ['v' => ['200','300','400','600','700','800','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['200','300','400','600','700','800','900'],'i' => ['400']],'Marvel' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Mate' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Mate SC' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Maven Pro' => ['v' => ['400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','900'],'i' => ['400']],'McLaren' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Meddon' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'MedievalSharp' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Medula One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Meera Inimai' => ['v' => ['400'],'s' => ['latin','tamil'],'w' => ['400'],'i' => ['400']],'Megrim' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Meie Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Merienda' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Merienda One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Merriweather' => ['v' => ['300','300italic','400','italic','700','700italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','700','900'],'i' => ['400','italic']],'Merriweather Sans' => ['v' => ['300','400','500','600','700','800','300italic','italic','500italic','600italic','700italic','800italic'],'s' => ['cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700','800','italic','600italic','800italic'],'i' => ['400','italic']],'Metal' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Metal Mania' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Metamorphous' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Metrophobic' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Michroma' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Milonga' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Miltonian' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Miltonian Tattoo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Mina' => ['v' => ['400','700'],'s' => ['bengali','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Miniver' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Miriam Libre' => ['v' => ['400','700'],'s' => ['hebrew','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Mirza' => ['v' => ['400','500','600','700'],'s' => ['arabic','latin','latin-ext'],'w' => ['400','500','600','700'],'i' => ['400']],'Miss Fajardose' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mitr' => ['v' => ['200','300','400','500','600','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400']],'Modak' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Modern Antiqua' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mogra' => ['v' => ['400'],'s' => ['gujarati','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Molengo' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Molle' => ['v' => ['italic'],'s' => ['latin','latin-ext'],'w' => [],'i' => ['400','italic']],'Monda' => ['v' => ['400','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Monofett' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Monoton' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Monsieur La Doulaise' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Montaga' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Montez' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Montserrat' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Montserrat Alternates' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Montserrat Subrayada' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Moul' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Moulpali' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Mountains of Christmas' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Mouse Memoirs' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mr Bedfort' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mr Dafoe' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mr De Haviland' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mrs Saint Delafield' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mrs Sheppards' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Mukta' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['devanagari','latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Mukta Mahee' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['gurmukhi','latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Mukta Malar' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['latin','latin-ext','tamil'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Mukta Vaani' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['gujarati','latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Mulish' => ['v' => ['200','300','400','500','600','700','800','900','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800','900','300italic','500italic','700italic','900italic'],'i' => ['400','italic']],'MuseoModerno' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Mystery Quest' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'NTR' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Nanum Brush Script' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Nanum Gothic' => ['v' => ['400','700','800'],'s' => ['korean','latin'],'w' => ['400','700','800'],'i' => ['400']],'Nanum Gothic Coding' => ['v' => ['400','700'],'s' => ['korean','latin'],'w' => ['400','700'],'i' => ['400']],'Nanum Myeongjo' => ['v' => ['400','700','800'],'s' => ['korean','latin'],'w' => ['400','700','800'],'i' => ['400']],'Nanum Pen Script' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Nerko One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Neucha' => ['v' => ['400'],'s' => ['cyrillic','latin'],'w' => ['400'],'i' => ['400']],'Neuton' => ['v' => ['200','300','400','italic','700','800'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','700','800'],'i' => ['400','italic']],'New Rocker' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'New Tegomin' => ['v' => ['400'],'s' => ['japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'News Cycle' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Newsreader' => ['v' => ['200','300','400','500','600','700','800','200italic','300italic','italic','500italic','600italic','700italic','800italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800','300italic','500italic','700italic'],'i' => ['400','italic']],'Niconne' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Niramit' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400','italic']],'Nixie One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nobile' => ['v' => ['400','italic','500','500italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','700'],'i' => ['400','italic']],'Nokora' => ['v' => ['400','700'],'s' => ['khmer'],'w' => ['400','700'],'i' => ['400']],'Norican' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Nosifer' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Notable' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nothing You Could Do' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Noticia Text' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Noto Sans' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','devanagari','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Noto Sans HK' => ['v' => ['100','300','400','500','700','900'],'s' => ['chinese-hongkong','latin'],'w' => ['100','300','400','500','700','900'],'i' => ['400']],'Noto Sans JP' => ['v' => ['100','300','400','500','700','900'],'s' => ['japanese','latin'],'w' => ['100','300','400','500','700','900'],'i' => ['400']],'Noto Sans KR' => ['v' => ['100','300','400','500','700','900'],'s' => ['korean','latin'],'w' => ['100','300','400','500','700','900'],'i' => ['400']],'Noto Sans SC' => ['v' => ['100','300','400','500','700','900'],'s' => ['chinese-simplified','latin'],'w' => ['100','300','400','500','700','900'],'i' => ['400']],'Noto Sans TC' => ['v' => ['100','300','400','500','700','900'],'s' => ['chinese-traditional','latin'],'w' => ['100','300','400','500','700','900'],'i' => ['400']],'Noto Serif' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Noto Serif JP' => ['v' => ['200','300','400','500','600','700','900'],'s' => ['japanese','latin'],'w' => ['200','300','400','500','600','700','900'],'i' => ['400']],'Noto Serif KR' => ['v' => ['200','300','400','500','600','700','900'],'s' => ['korean','latin'],'w' => ['200','300','400','500','600','700','900'],'i' => ['400']],'Noto Serif SC' => ['v' => ['200','300','400','500','600','700','900'],'s' => ['chinese-simplified','latin'],'w' => ['200','300','400','500','600','700','900'],'i' => ['400']],'Noto Serif TC' => ['v' => ['200','300','400','500','600','700','900'],'s' => ['chinese-traditional','latin'],'w' => ['200','300','400','500','600','700','900'],'i' => ['400']],'Nova Cut' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nova Flat' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nova Mono' => ['v' => ['400'],'s' => ['greek','latin'],'w' => ['400'],'i' => ['400']],'Nova Oval' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nova Round' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nova Script' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nova Slim' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nova Square' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Numans' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Nunito' => ['v' => ['200','200italic','300','300italic','400','italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['200','300','400','600','700','800','900'],'i' => ['400','italic']],'Nunito Sans' => ['v' => ['200','200italic','300','300italic','400','italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['200','300','400','600','700','800','900'],'i' => ['400','italic']],'Odibee Sans' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Odor Mean Chey' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Offside' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Oi' => ['v' => ['400'],'s' => ['greek','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Old Standard TT' => ['v' => ['400','italic','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Oldenburg' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Oleo Script' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Oleo Script Swash Caps' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Open Sans' => ['v' => ['300','300italic','400','italic','600','600italic','700','700italic','800','800italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','600','700','800'],'i' => ['400','italic']],'Open Sans Condensed' => ['v' => ['300','300italic','700'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['300','700'],'i' => ['400']],'Oranienbaum' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Orbitron' => ['v' => ['400','500','600','700','800','900'],'s' => ['latin'],'w' => ['400','500','600','700','800','900'],'i' => ['400']],'Oregano' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Orelega One' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Orienta' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Original Surfer' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Oswald' => ['v' => ['200','300','400','500','600','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400']],'Otomanopee One' => ['v' => ['400'],'s' => ['japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Over the Rainbow' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Overlock' => ['v' => ['400','italic','700','700italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['400','700','900'],'i' => ['400','italic']],'Overlock SC' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Overpass' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','600','700','800','900'],'i' => ['400','italic']],'Overpass Mono' => ['v' => ['300','400','600','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','600','700'],'i' => ['400']],'Ovo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Oxanium' => ['v' => ['200','300','400','500','600','700','800'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400']],'Oxygen' => ['v' => ['300','400','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400']],'Oxygen Mono' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'PT Mono' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'PT Sans' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'PT Sans Caption' => ['v' => ['400','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'PT Sans Narrow' => ['v' => ['400','700'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'PT Serif' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'PT Serif Caption' => ['v' => ['400','italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Pacifico' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Padauk' => ['v' => ['400','700'],'s' => ['latin','myanmar'],'w' => ['400','700'],'i' => ['400']],'Palanquin' => ['v' => ['100','200','300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['100','200','300','400','500','600','700'],'i' => ['400']],'Palanquin Dark' => ['v' => ['400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','500','600','700'],'i' => ['400']],'Pangolin' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Paprika' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Parisienne' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Passero One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Passion One' => ['v' => ['400','700','900'],'s' => ['latin','latin-ext'],'w' => ['400','700','900'],'i' => ['400']],'Pathway Gothic One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Patrick Hand' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Patrick Hand SC' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Pattaya' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext','thai','vietnamese'],'w' => ['400'],'i' => ['400']],'Patua One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Pavanam' => ['v' => ['400'],'s' => ['latin','latin-ext','tamil'],'w' => ['400'],'i' => ['400']],'Paytone One' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Peddana' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Peralta' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Permanent Marker' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Petit Formal Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Petrona' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Philosopher' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Piazzolla' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Piedra' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Pinyon Script' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Pirata One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Plaster' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Play' => ['v' => ['400','700'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Playball' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Playfair Display' => ['v' => ['400','500','600','700','800','900','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','900','500italic','700italic','900italic'],'i' => ['400','italic']],'Playfair Display SC' => ['v' => ['400','italic','700','700italic','900','900italic'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['400','700','900'],'i' => ['400','italic']],'Podkova' => ['v' => ['400','500','600','700','800'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Poiret One' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Poller One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Poly' => ['v' => ['400','italic'],'s' => ['latin'],'w' => ['400'],'i' => ['400','italic']],'Pompiere' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Pontano Sans' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Poor Story' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Poppins' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['devanagari','latin','latin-ext'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Port Lligat Sans' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Port Lligat Slab' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Potta One' => ['v' => ['400'],'s' => ['japanese','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Pragati Narrow' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Prata' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','vietnamese'],'w' => ['400'],'i' => ['400']],'Preahvihear' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Press Start 2P' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Pridi' => ['v' => ['200','300','400','500','600','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400']],'Princess Sofia' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Prociono' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Prompt' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Prosto One' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Proza Libre' => ['v' => ['400','italic','500','500italic','600','600italic','700','700italic','800','800italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700','800'],'i' => ['400','italic']],'Public Sans' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Puritan' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Purple Purse' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Qahiri' => ['v' => ['400'],'s' => ['arabic','latin'],'w' => ['400'],'i' => ['400']],'Quando' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Quantico' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Quattrocento' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Quattrocento Sans' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Questrial' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Quicksand' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Quintessential' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Qwigley' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Racing Sans One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Radley' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Rajdhani' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Rakkas' => ['v' => ['400'],'s' => ['arabic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Raleway' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Raleway Dots' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ramabhadra' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Ramaraja' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Rambla' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Rammetto One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ranchers' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Rancho' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Ranga' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Rasa' => ['v' => ['300','400','500','600','700'],'s' => ['gujarati','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Rationale' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Ravi Prakash' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Recursive' => ['v' => ['300','400','500','600','700','800','900'],'s' => ['cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700','800','900'],'i' => ['400']],'Red Hat Display' => ['v' => ['400','italic','500','500italic','700','700italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','700','900'],'i' => ['400','italic']],'Red Hat Text' => ['v' => ['400','italic','500','500italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','500','700'],'i' => ['400','italic']],'Red Rose' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Redressed' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Reem Kufi' => ['v' => ['400','500','600','700'],'s' => ['arabic','latin'],'w' => ['400','500','600','700'],'i' => ['400']],'Reenie Beanie' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Reggae One' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Revalia' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Rhodium Libre' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ribeye' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ribeye Marrow' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Righteous' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Risque' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Roboto' => ['v' => ['100','100italic','300','300italic','400','italic','500','500italic','700','700italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','300','400','500','700','900'],'i' => ['400','italic']],'Roboto Condensed' => ['v' => ['300','300italic','400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['300','400','700'],'i' => ['400','italic']],'Roboto Mono' => ['v' => ['100','200','300','400','500','600','700','100italic','200italic','300italic','italic','500italic','600italic','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','200italic','italic','600italic'],'i' => ['400','italic']],'Roboto Slab' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Rochester' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Rock Salt' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'RocknRoll One' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Rokkitt' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Romanesco' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ropa Sans' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Rosario' => ['v' => ['300','400','500','600','700','300italic','italic','500italic','600italic','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700','italic','600italic'],'i' => ['400','italic']],'Rosarivo' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Rouge Script' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Rowdies' => ['v' => ['300','400','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','700'],'i' => ['400']],'Rozha One' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Rubik' => ['v' => ['300','400','500','600','700','800','900','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','hebrew','latin','latin-ext'],'w' => ['300','400','500','600','700','800','900','italic','600italic','800italic'],'i' => ['400','italic']],'Rubik Mono One' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ruda' => ['v' => ['400','500','600','700','800','900'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','900'],'i' => ['400']],'Rufina' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Ruge Boogie' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ruluko' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Rum Raisin' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ruslan Display' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Russo One' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ruthie' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Rye' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'STIX Two Math' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Sacramento' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sahitya' => ['v' => ['400','700'],'s' => ['devanagari','latin'],'w' => ['400','700'],'i' => ['400']],'Sail' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Saira' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Saira Condensed' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Saira Extra Condensed' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Saira Semi Condensed' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Saira Stencil One' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Salsa' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Sanchez' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Sancreek' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sansita' => ['v' => ['400','italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['400','700','800','900'],'i' => ['400','italic']],'Sansita Swashed' => ['v' => ['300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700','800','900'],'i' => ['400']],'Sarabun' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['100','200','300','400','500','600','700','800'],'i' => ['400','italic']],'Sarala' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Sarina' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sarpanch' => ['v' => ['400','500','600','700','800','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','500','600','700','800','900'],'i' => ['400']],'Satisfy' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Sawarabi Gothic' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Sawarabi Mincho' => ['v' => ['400'],'s' => ['japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Scada' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Scheherazade' => ['v' => ['400','700'],'s' => ['arabic','latin'],'w' => ['400','700'],'i' => ['400']],'Schoolbell' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Scope One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Seaweed Script' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Secular One' => ['v' => ['400'],'s' => ['hebrew','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sedgwick Ave' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Sedgwick Ave Display' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Sen' => ['v' => ['400','700','800'],'s' => ['latin','latin-ext'],'w' => ['400','700','800'],'i' => ['400']],'Sevillana' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Seymour One' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Shadows Into Light' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Shadows Into Light Two' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Shanti' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Share' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Share Tech' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Share Tech Mono' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Shippori Mincho' => ['v' => ['400','500','600','700','800'],'s' => ['japanese','latin','latin-ext'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Shippori Mincho B1' => ['v' => ['400','500','600','700','800'],'s' => ['japanese','latin','latin-ext'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Shojumaru' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Short Stack' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Shrikhand' => ['v' => ['400'],'s' => ['gujarati','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Siemreap' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Sigmar One' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Signika' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Signika Negative' => ['v' => ['300','400','600','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','600','700'],'i' => ['400']],'Simonetta' => ['v' => ['400','italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['400','900'],'i' => ['400','italic']],'Single Day' => ['v' => ['400'],'s' => ['korean'],'w' => ['400'],'i' => ['400']],'Sintony' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Sirin Stencil' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Six Caps' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Skranji' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Slabo 13px' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Slabo 27px' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Slackey' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Smokum' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Smythe' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Sniglet' => ['v' => ['400','800'],'s' => ['latin','latin-ext'],'w' => ['400','800'],'i' => ['400']],'Snippet' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Snowburst One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sofadi One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Sofia' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Solway' => ['v' => ['300','400','500','700','800'],'s' => ['latin'],'w' => ['300','400','500','700','800'],'i' => ['400']],'Song Myung' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Sonsie One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sora' => ['v' => ['100','200','300','400','500','600','700','800'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','500','600','700','800'],'i' => ['400']],'Sorts Mill Goudy' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Source Code Pro' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','900'],'i' => ['400','italic']],'Source Sans Pro' => ['v' => ['200','200italic','300','300italic','400','italic','600','600italic','700','700italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext','vietnamese'],'w' => ['200','300','400','600','700','900'],'i' => ['400','italic']],'Source Serif Pro' => ['v' => ['200','200italic','300','300italic','400','italic','600','600italic','700','700italic','900','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['200','300','400','600','700','900'],'i' => ['400','italic']],'Space Grotesk' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Space Mono' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Spartan' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Special Elite' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Spectral' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400','italic']],'Spectral SC' => ['v' => ['200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700','800'],'i' => ['400','italic']],'Spicy Rice' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Spinnaker' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Spirax' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Squada One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Sree Krushnadevaraya' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Sriracha' => ['v' => ['400'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400'],'i' => ['400']],'Srisakdi' => ['v' => ['400','700'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400','700'],'i' => ['400']],'Staatliches' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Stalemate' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Stalinist One' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Stardos Stencil' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Stick' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Stint Ultra Condensed' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Stint Ultra Expanded' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Stoke' => ['v' => ['300','400'],'s' => ['latin','latin-ext'],'w' => ['300','400'],'i' => ['400']],'Strait' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Stylish' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Sue Ellen Francisco' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Suez One' => ['v' => ['400'],'s' => ['hebrew','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Sulphur Point' => ['v' => ['300','400','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','700'],'i' => ['400']],'Sumana' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Sunflower' => ['v' => ['300','500','700'],'s' => ['korean','latin'],'w' => ['300','500','700'],'i' => ['400']],'Sunshiney' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Supermercado One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Sura' => ['v' => ['400','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','700'],'i' => ['400']],'Suranna' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Suravaram' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Suwannaphum' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Swanky and Moo Moo' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Syncopate' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Syne' => ['v' => ['400','500','600','700','800'],'s' => ['latin','latin-ext'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Syne Mono' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Syne Tactile' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Tajawal' => ['v' => ['200','300','400','500','700','800','900'],'s' => ['arabic','latin'],'w' => ['200','300','400','500','700','800','900'],'i' => ['400']],'Tangerine' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Taprom' => ['v' => ['400'],'s' => ['khmer'],'w' => ['400'],'i' => ['400']],'Tauri' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Taviraj' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Teko' => ['v' => ['300','400','500','600','700'],'s' => ['devanagari','latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Telex' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Tenali Ramakrishna' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Tenor Sans' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Text Me One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Texturina' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Thasadith' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'The Girl Next Door' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Tienne' => ['v' => ['400','700','900'],'s' => ['latin'],'w' => ['400','700','900'],'i' => ['400']],'Tillana' => ['v' => ['400','500','600','700','800'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','500','600','700','800'],'i' => ['400']],'Timmana' => ['v' => ['400'],'s' => ['latin','telugu'],'w' => ['400'],'i' => ['400']],'Tinos' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','hebrew','latin','latin-ext','vietnamese'],'w' => ['400','700'],'i' => ['400','italic']],'Titan One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Titillium Web' => ['v' => ['200','200italic','300','300italic','400','italic','600','600italic','700','700italic','900'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','600','700','900'],'i' => ['400','italic']],'Tomorrow' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Tourney' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Trade Winds' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Train One' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Trirong' => ['v' => ['100','100italic','200','200italic','300','300italic','400','italic','500','500italic','600','600italic','700','700italic','800','800italic','900','900italic'],'s' => ['latin','latin-ext','thai','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400','italic']],'Trispace' => ['v' => ['100','200','300','400','500','600','700','800'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800'],'i' => ['400']],'Trocchi' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Trochut' => ['v' => ['400','italic','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Truculenta' => ['v' => ['100','200','300','400','500','600','700','800','900'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900'],'i' => ['400']],'Trykker' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Tulpen One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Turret Road' => ['v' => ['200','300','400','500','700','800'],'s' => ['latin','latin-ext'],'w' => ['200','300','400','500','700','800'],'i' => ['400']],'Ubuntu' => ['v' => ['300','300italic','400','italic','500','500italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext'],'w' => ['300','400','500','700'],'i' => ['400','italic']],'Ubuntu Condensed' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Ubuntu Mono' => ['v' => ['400','italic','700','700italic'],'s' => ['cyrillic','cyrillic-ext','greek','greek-ext','latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'Uchen' => ['v' => ['400'],'s' => ['latin','tibetan'],'w' => ['400'],'i' => ['400']],'Ultra' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Uncial Antiqua' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Underdog' => ['v' => ['400'],'s' => ['cyrillic','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Unica One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'UnifrakturCook' => ['v' => ['700'],'s' => ['latin'],'w' => ['700'],'i' => ['400']],'UnifrakturMaguntia' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Unkempt' => ['v' => ['400','700'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400']],'Unlock' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Unna' => ['v' => ['400','italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400','italic']],'VT323' => ['v' => ['400'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Vampiro One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Varela' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Varela Round' => ['v' => ['400'],'s' => ['hebrew','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Varta' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Vast Shadow' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Vesper Libre' => ['v' => ['400','500','700','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400','500','700','900'],'i' => ['400']],'Viaoda Libre' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Vibes' => ['v' => ['400'],'s' => ['arabic','latin'],'w' => ['400'],'i' => ['400']],'Vibur' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Vidaloka' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Viga' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Voces' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Volkhov' => ['v' => ['400','italic','700','700italic'],'s' => ['latin'],'w' => ['400','700'],'i' => ['400','italic']],'Vollkorn' => ['v' => ['400','500','600','700','800','900','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['cyrillic','cyrillic-ext','greek','latin','latin-ext','vietnamese'],'w' => ['400','500','600','700','800','900','500italic','700italic','900italic'],'i' => ['400','italic']],'Vollkorn SC' => ['v' => ['400','600','700','900'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400','600','700','900'],'i' => ['400']],'Voltaire' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Waiting for the Sunrise' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Wallpoet' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Walter Turncoat' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Warnes' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Wellfleet' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Wendy One' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Wire One' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Work Sans' => ['v' => ['100','200','300','400','500','600','700','800','900','100italic','200italic','300italic','italic','500italic','600italic','700italic','800italic','900italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['100','200','300','400','500','600','700','800','900','200italic','italic','600italic','800italic'],'i' => ['400','italic']],'Xanh Mono' => ['v' => ['400','italic'],'s' => ['latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400','italic']],'Yanone Kaffeesatz' => ['v' => ['200','300','400','500','600','700'],'s' => ['cyrillic','latin','latin-ext','vietnamese'],'w' => ['200','300','400','500','600','700'],'i' => ['400']],'Yantramanav' => ['v' => ['100','300','400','500','700','900'],'s' => ['devanagari','latin','latin-ext'],'w' => ['100','300','400','500','700','900'],'i' => ['400']],'Yatra One' => ['v' => ['400'],'s' => ['devanagari','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Yellowtail' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Yeon Sung' => ['v' => ['400'],'s' => ['korean','latin'],'w' => ['400'],'i' => ['400']],'Yeseva One' => ['v' => ['400'],'s' => ['cyrillic','cyrillic-ext','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Yesteryear' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Yomogi' => ['v' => ['400'],'s' => ['cyrillic','japanese','latin','latin-ext','vietnamese'],'w' => ['400'],'i' => ['400']],'Yrsa' => ['v' => ['300','400','500','600','700'],'s' => ['latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400']],'Yusei Magic' => ['v' => ['400'],'s' => ['japanese','latin','latin-ext'],'w' => ['400'],'i' => ['400']],'ZCOOL KuaiLe' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'ZCOOL QingKe HuangYou' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'ZCOOL XiaoWei' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'Zen Dots' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Zen Loop' => ['v' => ['400','italic'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400','italic']],'Zen Tokyo Zoo' => ['v' => ['400'],'s' => ['latin','latin-ext'],'w' => ['400'],'i' => ['400']],'Zeyada' => ['v' => ['400'],'s' => ['latin'],'w' => ['400'],'i' => ['400']],'Zhi Mang Xing' => ['v' => ['400'],'s' => ['chinese-simplified','latin'],'w' => ['400'],'i' => ['400']],'Zilla Slab' => ['v' => ['300','300italic','400','italic','500','500italic','600','600italic','700','700italic'],'s' => ['latin','latin-ext'],'w' => ['300','400','500','600','700'],'i' => ['400','italic']],'Zilla Slab Highlight' => ['v' => ['400','700'],'s' => ['latin','latin-ext'],'w' => ['400','700'],'i' => ['400']] ];
	}
}